/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.scoring;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Score {
    private int totalScore;
    public int numEating;
    public int numStudying;
    public int numBus;
    public int numRecreationalWalk;
    public int numRecreationalDuck;
    public int numRecreationalBar;
    public int numRecreationalFriends;
    public int numSleeping;
    private Map<Integer, ScoreActivity> activities;
    private static final Score instance = new Score();
    private int lastDay = 0;
    private int[] recActivityLog = new int[]{0, 0, 0, 0};

    private Score() {
        this.activities = new HashMap<Integer, ScoreActivity>();
        this.initializeActivities();
    }

    public static Score getInstance() {
        return instance;
    }

    private void initializeActivities() {
        this.addActivity(1, "Eating");
        this.addActivity(2, "Studying");
        this.addActivity(3, "Recreation");
        this.addActivity(4, "Sleeping");
        this.addActivity(5, "Achievements");
    }

    public void addActivity(int id, String name) {
        this.activities.put(id, new ScoreActivity(name));
    }

    public int hungerScore(int timeOfDay, int timeLastEat) {
        double x = timeOfDay - timeLastEat;
        int multiplier = 240;
        x /= (double)multiplier;
        x = Math.exp(x) / (1.0 + Math.exp(x)) - 0.5;
        int maxScore = 500;
        return (int)Math.round((double)maxScore * x);
    }

    public int activityScore(int activityType, int currentDay) {
        if (this.lastDay != currentDay) {
            this.lastDay = currentDay;
            this.recActivityLog = new int[]{0, 0, 0, 0, 0};
        }
        int n = activityType;
        this.recActivityLog[n] = this.recActivityLog[n] + 1;
        int recreationScore = 200;
        return recreationScore / this.recActivityLog[activityType];
    }

    public int getTotalScore() {
        return this.totalScore;
    }

    public int getNumRecreationalWalk() {
        return this.numRecreationalWalk;
    }

    public int getNumRecreationalDuck() {
        return this.numRecreationalDuck;
    }

    public int getNumStudying() {
        return this.numStudying;
    }

    public int getNumSleeping() {
        return this.numSleeping;
    }

    public void incrementTotalScore(int id, int scoreToAdd) {
        this.totalScore += scoreToAdd;
        ScoreActivity activity = this.activities.get(id);
        if (activity != null) {
            activity.addScore(scoreToAdd);
        }
    }

    public void incrementNumEating() {
        ++this.numEating;
    }

    public void incrementNumBus() {
        ++this.numBus;
    }

    public void incrementNumRecreationalWalk() {
        ++this.numRecreationalWalk;
    }

    public void incrementNumRecreationalDuck() {
        ++this.numRecreationalDuck;
    }

    public void incrementNumRecreationalBar() {
        ++this.numRecreationalBar;
    }

    public void incrementNumRecreationalFriends() {
        ++this.numRecreationalFriends;
    }

    public void incrementNumStudying() {
        ++this.numStudying;
    }

    public void incrementNumSleeping() {
        ++this.numSleeping;
    }

    public void setTotalScore(int value) {
        this.totalScore = value;
    }

    public void resetScores() {
        this.totalScore = 0;
        this.numEating = 0;
        this.numBus = 0;
        this.numRecreationalWalk = 0;
        this.numRecreationalDuck = 0;
        this.numRecreationalBar = 0;
        this.numRecreationalFriends = 0;
        this.numStudying = 0;
        this.numSleeping = 0;
        this.activities.values().forEach(ScoreActivity::resetScore);
        this.recActivityLog = new int[]{0, 0, 0, 0};
    }

    public String getUserScores() {
        return this.activities.values().stream().map(activity -> activity.getName() + ": " + activity.getScore() + "\n").collect(Collectors.joining());
    }

    public int getScoreByActivity(int id) {
        return this.activities.containsKey(id) ? this.activities.get(id).getScore() : 0;
    }

    public Map getActivities() {
        return this.activities;
    }

    public class ScoreActivity {
        private String name;
        private int score;

        public ScoreActivity(String name) {
            this.name = name;
            this.score = 0;
        }

        public void addScore(int amount) {
            this.score += amount;
        }

        public String getName() {
            return this.name;
        }

        public int getScore() {
            return this.score;
        }

        public void resetScore() {
            this.score = 0;
        }
    }
}

